#!/bin/sh
# configversion: f1282bb39c782471bb788ccf8df0bb76
# SPDX-License-Identifier: AGPL-3.0-only
# Copyright 2022 Sxmo Contributors
# shellcheck disable=SC2154

# include common definitions \
# shellcheck source=configs/default_hooks/sxmo_hook_icons.sh
. sxmo_hook_icons.sh

write_line() {
	printf "%s ^ 0 ^ %s\n" "$1" "$2"
}

write_line_app() {
	executable="$1"
	label="$2"
	command="$3"
	if command -v "$executable" >/dev/null; then
		write_line "$label" "$command"
	fi
}

[ -n "$PLAN9" ] && write_line_app acme "$icon_edt Acme" "acme -c 1 -f $PLAN9/font/pelm/ascii.16.font"
write_line_app adventure "$icon_trm Adventure" "sxmo_terminal.sh adventure"
write_line_app aerc "$icon_eml Aerc" "sxmo_terminal.sh aerc"
write_line_app alacritty "$icon_trm Alacritty" "alacritty"
write_line_app amberol "$icon_mus Amberol" "amberol $XDG_MUSIC_DIR"
write_line_app harbour-amazfish-ui "$icon_wat Amazfish" "harbour-amazfish-ui"
write_line_app amfora "$icon_glb Amfora" "sxmo_terminal.sh amfora"
write_line_app angelfish "$icon_glb Angelfish" "angelfish"
write_line_app animatch "$icon_gam Animatch" "animatch"
write_line_app alpine "$icon_eml Alpine" "sxmo_terminal.sh alpine"
write_line_app anbox-launch "$icon_and Anbox" "anbox"
write_line_app anki "$icon_str Anki" "anki"
write_line_app audacity "$icon_mic Audacity" "audacity"
write_line_app badwolf "$icon_glb Badwolf" "badwolf"
write_line_app baobab "$icon_pie Baobab" "baobab"
write_line_app bluetuith "$icon_bth Bluetuith" "sxmo_terminal.sh bluetuith"
write_line_app calcurse "$icon_clk Calcurse" "sxmo_terminal.sh calcurse"
write_line_app celluloid "$icon_mvi Celluloid" "celluloid"
write_line_app chatty "$icon_msg Chatty" "chatty"
([ -z "$WAYLAND_DISPLAY" ] && command -v clipmenu >/dev/null) && \
	write_line_app clipmenu "$icon_bok Clipmenu" "clipmenu"
write_line_app cmus "$icon_mus Cmus" "sxmo_terminal.sh cmus"
write_line_app com.github.geigi.cozy "$icon_mus Cozy" "com.github.geigi.cozy"
write_line_app cpupower-gui "$icon_cfg Cpupower-gui" "cpupower-gui"
write_line_app deja-dup "$icon_bkp Déjà Dup" "deja-dup"
write_line_app dialect "$icon_tsl Dialect" "dialect"
write_line_app dino "$icon_msg Dino" "GDK_SCALE=1 dino"
write_line_app dissent "$icon_dis Dissent" "dissent"
write_line_app dolphin "$icon_dir Dolphin" "dolphin"
write_line_app drawing "$icon_drw Drawing" "drawing"
write_line_app eartag "$icon_mus Ear Tag" "eartag"
write_line_app elinks "$icon_glb ELinks" "sxmo_terminal.sh elinks"
write_line_app emacs "$icon_ema Emacs (Terminal)" "sxmo_terminal.sh emacs -nw"
write_line_app emacs "$icon_ema Emacs (X)" "emacs"
write_line_app eog "$icon_img Eye of Gnome" "eog"
write_line_app epiphany "$icon_glb Epiphany" "epiphany"
write_line_app epy "$icon_bok Epy" "sxmo_terminal.sh epy"
write_line_app epr "$icon_bok Epr" "sxmo_terminal.sh epr"
write_line_app errands "$icon_lst Errands" "errands"
write_line_app evince "$icon_bok Evince" "evince"
write_line_app falkon "$icon_flk Falkon" "falkon"
write_line_app file-roller "$icon_zip File Roller" "file-roller"
write_line_app firefox "$icon_ffx Firefox" "firefox"
write_line_app firefox-esr "$icon_ffx Firefox ESR" "firefox-esr"
write_line_app flare "$icon_msg Flare" "flare"
write_line_app flowtime "$icon_hrg Flowtime" "flowtime"
write_line_app foliate "$icon_bok Foliate" "foliate"
( [ -n "$WAYLAND_DISPLAY" ] && command -v foot >/dev/null) && \
	write_line "$icon_trm Foot" "foot $SHELL"
write_line_app foxtrotgps "$icon_gps Foxtrotgps" "foxtrotgps"
write_line_app fractal "$icon_msg Fractal" "fractal"
write_line_app fragments "$icon_rld Fragments" "fragments"
write_line_app g4music "$icon_mus G4Music" "g4music"
write_line_app geany "$icon_edt Geany" "geany"
write_line_app geary "$icon_eml Geary" "geary"
write_line_app gedit "$icon_edt Gedit" "gedit"
write_line_app geeqie "$icon_img Geeqie" "geeqie"
write_line_app geopard "$icon_glb Geopard" "geopard"
write_line_app gerbil "$icon_glb Gerbil" "gerbil"
write_line_app giara "$icon_red Giara" "giara"
write_line_app gnome-2048 "$icon_gam Gnome 2048" "gnome-2048"
write_line_app authenticator "$icon_2fa Gnome Authenticator" "authenticator"
write_line_app gnome-calculator "$icon_clc Gnome Calculator" "gnome-calculator"
write_line_app gnome-calendar "$icon_cal Gnome Calendar" "gnome-calendar"
write_line_app gnome-calls "$icon_phn Gnome Calls" "gnome-calls"
write_line_app gnome-characters "$icon_emj Gnome Characters" "gnome-characters"
write_line_app gnome-chess "$icon_chs Gnome Chess" "gnome-chess"
write_line_app gnome-clocks "$icon_clk Gnome Clocks" "gnome-clocks"
write_line_app kgx "$icon_trm Gnome Console" "kgx"
write_line_app gnome-contacts "$icon_usr Gnome Contacts" "gnome-contacts"
write_line_app gnome-disks "$icon_dsk Gnome Disks" "gnome-disks"
write_line_app gnome-firmware "$icon_cfg Gnome Firmware" "gnome-firmware"
write_line_app gnome-font-viewer "$icon_ltr Gnome Fonts" "gnome-font-viewer"
write_line_app gnome-maps "$icon_map Gnome Maps" "gnome-maps"
write_line_app metronome "$icon_mtr Gnome Metronome" "metronome"
write_line_app gnome-podcasts "$icon_pod Gnome Podcasts" "gnome-podcasts"
write_line_app gnome-software "$icon_bag Gnome Software" "gnome-software"
write_line_app gnome-sound-recorder "$icon_mic Gnome Sound Recorder" "gnome-sound-recorder"
write_line_app gnome-sudoku "$icon_num Gnome Sudoku" "gnome-sudoku"
write_line_app gnome-taquin "$icon_pzl Gnome Taquin" "gnome-taquin"
write_line_app gnome-text-editor "$icon_edt Gnome Text Editor" "gnome-text-editor"
write_line_app gnome-weather "$icon_wtr Gnome Weather" "gnome-weather"
write_line_app gomuks "$icon_msg Gomuks" "sxmo_terminal.sh gomuks"
write_line_app gpodder "$icon_pod gPodder" "gpodder"
write_line_app gucharmap "$icon_inf Gucharmap" "gucharmap"
write_line_app hexchat "$icon_msg Hexchat" "hexchat"
write_line_app htop "$icon_spd Htop" "sxmo_terminal.sh htop"
write_line_app iamb "$icon_msg Iamb" "sxmo_terminal.sh iamb"
write_line_app irssi "$icon_msg Irssi" "sxmo_terminal.sh irssi"
write_line_app ii "$icon_msg Ii" "sxmo_terminal.sh ii"
write_line_app ipython "$icon_trm IPython" "sxmo_terminal.sh ipython"
write_line_app index "$icon_dir Index" "index"
write_line_app itinerary "$icon_map Itinerary" "itinerary"
write_line_app jami-qt "$icon_msg Jami" "jami-qt"
write_line_app kasts "$icon_pod Kasts" "kasts"
write_line_app kcalc "$icon_clc KCalc" "kcalc"
write_line_app kid3-cli "$icon_mus Kid3 Cli" "sxmo_terminal.sh kid3-cli"
write_line_app kid3-qml "$icon_mus Kid3 QML" "kid3-qml"
write_line_app kmail "$icon_eml KMail" "kmail"
write_line_app komikku "$icon_bok Komikku" "komikku"
write_line_app kontact "$icon_msg Kontact" "kontact"
write_line_app konversation "$icon_msg Konversation" "konversation"
write_line_app koreader "$icon_bok KOReader" "koreader"
write_line_app krita "$icon_img Krita" "krita --nosplash"
write_line_app kwrite "$icon_edt Kwrite" "kwrite"
write_line_app lagrange "$icon_glb Lagrange" "lagrange"
write_line_app lf "$icon_dir Lf" "sxmo_terminal.sh lf"
write_line_app librewolf "$icon_glb LibreWolf" "librewolf"
write_line_app links "$icon_glb Links" "sxmo_terminal.sh links"
write_line_app links "$icon_glb Links (GUI)" "links -g"
write_line_app org.localsend.localsend_app "$icon_fsn LocalSend" "org.localsend.localsend_app"
write_line_app lollypop "$icon_mus Lollypop" "lollypop"
write_line_app loupe "$icon_img Loupe" "loupe"
write_line_app lpa-gtk "$icon_sim Lpa Gtk" "lpa-gtk"
write_line_app luakit "$icon_glb Luakit" "luakit"
write_line_app luanti "$icon_gam Luanti" "luanti"
write_line_app marble "$icon_map Marble" "marble"
write_line_app megapixels "$icon_cam Megapixels" "megapixels"
write_line_app mepo "$icon_map Mepo" "mepo"
write_line_app micro "$icon_edt Micro" "sxmo_terminal.sh micro"
write_line_app midori "$icon_glb Midori" "midori"
write_line_app moment "$icon_msg Moment" "moment"
write_line_app mupdf "$icon_bok Mupdf" "mupdf"
write_line_app mupdf-gl "$icon_bok Mupdf-gl" "mupdf-gl"
write_line_app mutt "$icon_eml Mutt" "sxmo_terminal.sh mutt"
write_line_app mumble "$icon_grp Mumble" mumble
write_line_app nano "$icon_edt Nano" "sxmo_terminal.sh nano"
write_line_app nautilus "$icon_dir Nautilus" "nautilus"
write_line_app navit "$icon_gps Navit" "navit"
write_line_app ncmpcpp "$icon_mus Ncmpcpp" "sxmo_terminal.sh ncmpcpp"
write_line_app neomutt "$icon_eml Neomutt" "sxmo_terminal.sh neomutt"
write_line_app nethack "$icon_trm Nethack" "sxmo_terminal.sh nethack"
write_line_app nheko "$icon_msg Nheko" "nheko"
write_line_app nvim "$icon_nvi Neovim" "sxmo_terminal.sh nvim"
write_line_app netsurf "$icon_glb Netsurf" "netsurf"
write_line_app newsboat "$icon_rss Newsboat" "sxmo_terminal.sh newsboat"
write_line_app com.gitlab.newsflash "$icon_rss Newsflash" com.gitlab.newsflash
write_line_app newsraft "$icon_rss Newsraft" "sxmo_terminal.sh newsraft"
write_line_app nnn "$icon_dir Nnn" "sxmo_terminal.sh nnn"
write_line_app numberstation "$icon_2fa Numberstation" "numberstation"
write_line_app nyxt "$icon_glb Nyxt" "nyxt"
write_line_app offpunk "$icon_glb Offpunk" "sxmo_terminal.sh offpunk"
write_line_app onboard-settings "$icon_cfg Onboard Settings" onboard-settings
write_line_app osmin "$icon_map Osmin" "osmin"
write_line_app papers "$icon_bok Papers" "papers"
write_line_app passes "$icon_psp Passes" "passes"
write_line_app pavucontrol "$icon_mus Pavucontrol" "pavucontrol"
write_line_app pidgin "$icon_msg Pidgin" "pidgin"
write_line_app tubefeeder "$icon_mvi Pipeline" "tubefeeder"
write_line_app podboat "$icon_pod Podboat" "sxmo_terminal.sh podboat"
write_line_app polari "$icon_msg Polari" "polari"
write_line_app dev.tchx84.Portfolio "$icon_dir Portfolio" "dev.tchx84.Portfolio"
write_line_app profanity "$icon_msg Profanity" "sxmo_terminal.sh profanity"
write_line_app ptyxis "$icon_trm Ptyxis" "ptyxis"
write_line_app pulsemixer "$icon_mus Pulsemixer" "sxmo_terminal.sh pulsemixer"
write_line_app pure-maps "$icon_map Pure Maps" "pure-maps"
write_line_app qalc "$icon_clc Qalc" "sxmo_terminal.sh qalc"
write_line_app qutebrowser "$icon_glb Qutebrowser" "qutebrowser"
write_line_app radio-cli "$icon_rad Radio Cli" "sxmo_terminal.sh radio-cli"
write_line_app railway "$icon_trn Railway" "railway"
write_line_app ranger "$icon_dir Ranger" "sxmo_terminal.sh ranger"
write_line_app resources "$icon_spd Resources" "resources"
write_line_app sacc "$icon_glb Sacc" "sxmo_terminal.sh sacc i-logout.cz/1/bongusta"
write_line_app secrets "$icon_lck Secrets" "secrets"
write_line_app screen "$icon_msg Screen" "sxmo_terminal.sh screen"
write_line_app seahorse "$icon_key Seahorse" "seahorse"
write_line_app senpai "$icon_msg Senpai" "sxmo_terminal.sh senpai"
write_line_app shortwave "$icon_rad Shortwave" "shortwave"
write_line_app sic "$icon_msg Sic" "sxmo_terminal.sh sic"
write_line_app siglo "$icon_clk Siglo" "siglo"
write_line_app simple-scan "$icon_scn Simple Scan" "simple-scan"
write_line_app snapshot "$icon_cam Snapshot" "snapshot"
write_line_app solanum "$icon_pom Solanum" "solanum"
([ -z "$WAYLAND_DISPLAY" ] && command -v st >/dev/null) && \
	write_line "$icon_trm St" "st -e $SHELL"
write_line_app supertuxkart "$icon_krt SuperTuxKart" "supertuxkart"
write_line_app surf "$icon_glb Surf" "surf"
write_line_app syncthing "$icon_rld Syncthing" "syncthing"
write_line_app syncthing-gtk "$icon_rld Syncthing GTK" "syncthing-gtk"
([ -z "$WAYLAND_DISPLAY" ] && command -v tabbed >/dev/null) && \
	write_line_app tabbed "$icon_grd Tabbed" "sxmo_tabbed.sh"
write_line_app telegram-desktop "$icon_tgm Telegram" "telegram-desktop"
write_line_app termite "$icon_trm Termite" "termite -e $SHELL"
write_line_app thunar "$icon_dir Thunar" "sxmo_terminal.sh thunar"
write_line_app thunderbird "$icon_thu Thunderbird" "thunderbird"
write_line_app tilix "$icon_trm Tilix" "tilix"
write_line_app com.github.bleakgrey.tootle "$icon_msg Tootle" "com.github.bleakgrey.tootle"
write_line_app re.sonny.Tangram "$icon_glb Tangram" "re.sonny.Tangram"
write_line_app totem "$icon_mvi Totem" "totem"
write_line_app dev.geopjr.Tuba "$icon_msg Tuba" "dev.geopjr.Tuba"
write_line_app tuir "$icon_red Tuir" "sxmo_terminal.sh tuir"
write_line_app tut "$icon_msg Tut" "sxmo_terminal.sh tut"
write_line_app warp "$icon_fsn Warp" "warp"
write_line_app waydroid "$icon_and Waydroid" "waydroid show-full-ui"
write_line_app weechat "$icon_msg Weechat" "sxmo_terminal.sh weechat"
write_line_app wike "$icon_bok Wike" "wike"
write_line_app w3m "$icon_glb W3m" "sxmo_terminal.sh w3m duck.com"
write_line_app vim "$icon_vim Vim" "sxmo_terminal.sh vim"
write_line_app vimb "$icon_glb Vimb" "vimb"
write_line_app vimb "$icon_glb Vimb (Incognito)" "vimb -i"
write_line_app vis "$icon_vim Vis" "sxmo_terminal.sh vis"
write_line_app vlc "$icon_vlc Vlc" "vlc"
write_line_app vte-2.91 "$icon_trm VTE 3" "vte-2.91"
write_line_app vte-2.91-gtk4 "$icon_trm VTE 3 (GTK-4)" "vte-2.91-gtk4"
([ -z "$WAYLAND_DISPLAY" ] && command -v xcalc >/dev/null) && \
	write_line "$icon_clc Xcalc" "xcalc"
write_line_app xfce4-terminal "$icon_trm XFCE4 Terminal" "xfce4-terminal"
write_line_app xournal "$icon_bok Xournal" "xournal"
write_line_app xournalpp "$icon_bok Xournalpp" "xournalpp"
write_line_app zapzap "$icon_wap ZapZap" "zapzap"
write_line_app zathura "$icon_bok Zathura" "zathura"
